/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWStepAssignmentsSubPanel;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCustomTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class VWStepAssignmentsTab
extends JPanel
implements IVWPropertyTab,
ChangeListener,
IVWPropertyChangeListener,
IVWTableActionListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private boolean m_bEnablePre = true;
    private VWCustomTabbedPane m_tabbedPane = null;
    private VWStepAssignmentsSubPanel m_preAssignmentsPanel = null;
    private VWStepAssignmentsSubPanel m_postAssignmentsPanel = null;

    VWStepAssignmentsTab(boolean bEnablePre) {
        this.m_bEnablePre = bEnablePre;
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.setSelectedStep(vwMapNode);
            this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        this.stopEditing();
        try {
            if (this.m_preAssignmentsPanel != null) {
                this.m_preAssignmentsPanel.setSelectedStep((VWStepDefinition)vwMapNode);
            }
            if (this.m_postAssignmentsPanel != null) {
                this.m_postAssignmentsPanel.setSelectedStep((VWStepDefinition)vwMapNode);
            }
            if (this.m_tabbedPane != null && this.m_tabbedPane.getTabCount() > 0) {
                this.m_tabbedPane.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.removeChangeListener(this);
            this.m_tabbedPane.releaseReferences();
            this.m_tabbedPane = null;
        }
        if (this.m_preAssignmentsPanel != null) {
            this.m_preAssignmentsPanel.releaseReferences();
            this.m_preAssignmentsPanel = null;
        }
        if (this.m_postAssignmentsPanel != null) {
            this.m_postAssignmentsPanel.releaseReferences();
            this.m_postAssignmentsPanel = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource().equals(this.m_tabbedPane)) {
            this.stopEditing();
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            switch (event.getID()) {
                case 521: 
                case 522: 
                case 523: 
                case 553: {
                    this.reinitialize();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                this.stopEditing();
            }
        }
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_tabbedPane = new VWCustomTabbedPane(1);
            this.add((Component)this.m_tabbedPane, "Center");
            if (this.m_bEnablePre) {
                this.m_preAssignmentsPanel = new VWStepAssignmentsSubPanel(this.m_authPropertyData, 0);
                if (this.m_preAssignmentsPanel != null) {
                    this.m_tabbedPane.addTab(VWResource.s_beforeExecutionStr, this.m_preAssignmentsPanel);
                }
            }
            this.m_postAssignmentsPanel = new VWStepAssignmentsSubPanel(this.m_authPropertyData, 1);
            if (this.m_postAssignmentsPanel != null) {
                this.m_tabbedPane.addTab(VWResource.s_afterCompletionStr, this.m_postAssignmentsPanel);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void stopEditing() {
        if (this.m_preAssignmentsPanel != null) {
            this.m_preAssignmentsPanel.stopEditing();
        }
        if (this.m_postAssignmentsPanel != null) {
            this.m_postAssignmentsPanel.stopEditing();
        }
    }

    protected void reinitialize() {
        if (this.m_preAssignmentsPanel != null) {
            this.m_preAssignmentsPanel.reinitialize();
        }
        if (this.m_postAssignmentsPanel != null) {
            this.m_postAssignmentsPanel.reinitialize();
        }
    }
}

